<?php
session_start();
require_once 'database.php';
require_once 'security.php';

$security = new Security($pdo);
$erro = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $login = $security->cleanInput($_POST['login']);
    $senha = $_POST['senha'];
    $recaptcha_response = $_POST['g-recaptcha-response'] ?? '';
    
    // Verificar reCAPTCHA v2
    if (!$security->verifyRecaptcha($recaptcha_response)) {
        $erro = "Por favor, confirme que você não é um robô.";
    }
    // Verificar tentativas de login
    elseif (!$security->checkLoginAttempts($login)) {
        $erro = "Muitas tentativas de login. Tente novamente em 15 minutos.";
    }
    else {
        $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE login = ?");
        $stmt->execute([$login]);
        $usuario = $stmt->fetch();
        
        if ($usuario && password_verify($senha, $usuario['senha'])) {
            // Login bem-sucedido
            $security->resetLoginAttempts($login);
            $security->secureSession();
            
            $_SESSION['usuario_id'] = $usuario['id'];
            $_SESSION['usuario_nome'] = $usuario['nome'];
            $_SESSION['usuario_tipo'] = $usuario['tipo'];
            $_SESSION['usuario_login'] = $usuario['login'];
            $_SESSION['login_time'] = time();
            $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
            $_SESSION['ip_address'] = $_SERVER['REMOTE_ADDR'];
            
            // Registrar login bem-sucedido
            $stmt = $pdo->prepare("UPDATE usuarios SET ultimo_login = NOW() WHERE id = ?");
            $stmt->execute([$usuario['id']]);
            
            header("Location: index.php");
            exit();
        } else {
            // Login falhou
            $security->incrementLoginAttempts($login);
            $erro = "Login ou senha incorretos!";
        }
    }
}

// Gerar token CSRF para o formulário
$csrf_token = $security->generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Gestor DREEYTV</title>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo h1 {
            font-size: 2.5rem;
            background: linear-gradient(135deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 10px;
        }
        
        .logo p {
            color: #666;
            font-size: 1rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 2px solid #e1e5e9;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            outline: none;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .btn:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
        
        .alert {
            padding: 15px;
            background: #fee;
            border: 1px solid #fcc;
            border-radius: 10px;
            margin-bottom: 20px;
            color: #c00;
        }
        
        .credentials {
            margin-top: 25px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
            text-align: center;
            font-size: 0.9rem;
        }
        
        .credentials strong {
            color: #667eea;
        }
        
        .security-notice {
            margin-top: 15px;
            padding: 10px;
            background: #e8f4fd;
            border-radius: 8px;
            text-align: center;
            font-size: 0.8rem;
            color: #0066cc;
        }
        
        .recaptcha-container {
            margin: 20px 0;
            display: flex;
            justify-content: center;
        }
        
        .g-recaptcha {
            transform: scale(0.9);
            transform-origin: 0 0;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h1>📺 GESTOR</h1>
            <p>Sistema de Gestão Premium</p>
        </div>
        
        <?php if ($erro): ?>
            <div class="alert">
                <strong>Erro:</strong> <?php echo $erro; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" id="loginForm">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            
            <div class="form-group">
                <label for="login">👤 Usuário</label>
                <input type="text" id="login" name="login" class="form-control" placeholder="Digite seu usuário" required 
                       value="<?php echo isset($_POST['login']) ? htmlspecialchars($_POST['login']) : ''; ?>">
            </div>
            
            <div class="form-group">
                <label for="senha">🔒 Senha</label>
                <input type="password" id="senha" name="senha" class="form-control" placeholder="Digite sua senha" required>
            </div>
            
            <div class="recaptcha-container">
                <div class="g-recaptcha" data-sitekey=" sua chave SITE KEY"></div>
            </div>
            
            <button type="submit" class="btn" id="loginBtn">🚀 Acessar Sistema</button>
        </form>
        
        <div class="security-notice">
            🔒 Protegido por reCAPTCHA e sistemas de segurança avançados
        </div>
        
        <div class="credentials">
            <p><strong>GESTOR DRREYTV:</strong></p>
            <p><strong>BEM-VINDO AO  GESTOR DREEYTV – Mais canais, mais entretenimento</strong></p>
        </div>
    </div>

    <script>
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const recaptchaResponse = grecaptcha.getResponse();
            if (recaptchaResponse.length === 0) {
                e.preventDefault();
                alert('Por favor, confirme que você não é um robô.');
                return false;
            }
            
            const btn = document.getElementById('loginBtn');
            btn.disabled = true;
            btn.innerHTML = '⏳ Verificando...';
        });
    </script>
</body>
</html>